%DEMO Demo using the Toshiba CAD model point clouds dataset
%
% This script demonstrates use of the Toshiba CAD model point clouds
% dataset. It calls
%
%   demo_features
%
% which shows how the provided point clouds relate to the model meshes and
% also the extracted features. It also calls
%
%   demo_inference
%
% which shows how the provided votes files can be used to detect objects,
% and how the results can be evaluated quantitatively.
%
% This code requires that you have downloaded (from the same place as this
% code) and extracted the zip files containing:
%    points
%    features
%    votes
%    rotational symmetries
%
% and downloaded the MATLAB function stlread from:
%    http://www.mathworks.com/matlabcentral/fileexchange/29906-binary-stl-file-reader

close all;

class = ceil(rand(1) * 10); % 1,..,10
instance = ceil(rand(1) * 20); % 1,..,20
test = ceil(rand(1) * 5); % 1,..,5

demo_features(class, instance);

demo_inference(class, instance, test);