%DEMO_FEATURES Display features for a particular point cloud

function demo_features(class, id)

% Default values
if nargin < 2
    id = 1;
    if nargin < 1
        class = 1;
    end
end

% Get the points, features, mesh
[V E] = get_mesh(class);
[T X] = get_points(class, id);
F = get_features(class, id);

% Transform the points into the mesh coordinate frame
X = pose2M(T) * [X; ones(1, size(X, 2))];

% Render the data
figure;
h = render_mesh(V, E);
alpha(h, 0.5);
hold on
render_points(X, [0 1 1]);
render_features(F);
hold off
axis equal off
set(gcf, 'color', 'w');
view(3);
light;