%DEMO_INFERENCE Demonstrate inference for a given test case

function demo_inference(class, id, test)

% Default values
if nargin < 3
    test = 1;
    if nargin < 2
        id = 1;
        if nargin < 1
            class = 1;
        end
    end
end

% Get the votes
votes = get_votes(class, id, test);

% Make class id 1 based
votes(2,:) = votes(2,:) + 1;

% Run intrinsic Hough on the votes - get back a sorted list of modes and
% their weights
modes = intrinsic_hough(votes(:,2:end));

% Compute the recognition and registration score for each mode found
Mgt = votes(:,1);
[rec reg Breg] = evaluate_result(Mgt, modes);

% Get poses of the first result and the first result of the correct class
Mrec = modes(:,1);
if rec(1)
    Mreg = Mrec;
else
    % Find the best mode of the right class
    a = find(rec, 1);
    if isempty(a)
        Mreg = [];
    else
        Mreg = modes(:,a);
    end
end

% Render the result
[V E] = get_mesh(class);
V = [V; ones(1, size(V, 2))];
Vgt = pose2M(Mgt(3:10)) * V;

figure;
% Render the ground truth - gray
h = render_mesh(Vgt, E);
alpha(h, 0.5);

hold on
if ~isempty(Mreg)
    % Render the best in class - green
    V = pose2M(Mreg(3:10)) * V;
    h = render_mesh(V, E, [0 0.6 0]);
    alpha(h, 0.5);
end

if ~rec(1)
    % Render the best overall - red
    [V E] = get_mesh(Mrec(2));
    V = pose2M(Mrec(3:10)) * [V; ones(1, size(V, 2))];
    h = render_mesh(V, E, [0.7 0 0]);
    alpha(h, 0.5);
end

% Display the text
text(0, 1, {['Class: ' num2str(rec(1))], ['Scale: ' num2str(Breg(1))], ['Rotation: ' num2str(Breg(2))], ['Translation: ' num2str(Breg(3))]}, ...
     'Units', 'normalized', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'top');

hold off
axis equal off
light;
set(gcf, 'color', 'w');