%EVALUATE_RESULT Compute recognition and registration success

function [rec reg Breg] = evaluate_result(gt, modes)

% Compute recognition score
rec = gt(2) == modes(2,:);

% Compute the acceptable rotations
rot = get_symmetries(gt(2));
rot = quat_mult(gt([10 7:9]), rot([8 5:7],:)); % Compose, accounting for difference in quaternion storage
rot(1,:) = -rot(1,:); % Invert now

% Compute registration
reg = false(size(rec));
L = find(rec);
if isempty(L)
    Breg = false(1, 3);
    return;
end
% Compute and store registration for the first correctly recognized result
a = L(1);
Bscale = abs(log(modes(6,a) / gt(6))) < 0.05; % Eq. 19
Btrans = (norm(modes(3:5,a) - gt(3:5)) / sqrt(modes(6,a) * gt(6))) < 0.1; % Eq. 21
Brot = min(acos((trace3x3(quat2rot(quat_mult(rot, modes([10 7:9],a)))) - 1) / 2)) < (pi / 12); % Eq. 20
Breg = [Bscale Brot Btrans];
if all(Breg)
    reg(a) = true;
    return;
end
% Go through all the other results to see if we have one correctly
% registered
for a = L(2:end)
    Bscale = abs(log(modes(6,a) / gt(6))) < 0.05; % Eq. 19
    if ~Bscale
        continue; % Wrong scale
    end
    Btrans = (norm(modes(3:5,a) - gt(3:5)) / sqrt(modes(6,a) * gt(6))) < 0.01; % Eq. 21
    if ~Btrans
        continue; % Wrong translation
    end
    Brot = min(acos((trace3x3(quat2rot(quat_mult(rot, modes([10 7:9])))) - 1) / 2)) < (pi / 12); % Eq. 20
    if ~Brot
        continue; % Wrong rotation
    end
    reg(a) = true;
    return; % Only one object can be correctly registered per test
end

function A = trace3x3(A)
% Compute trace of each 3x3 matrix in a multi-dimensional array
A = sum(A(bsxfun(@plus, [1; 5; 9], 9 * (0:size(A, 3)-1))));