%GET_PATH_STRING Helper function to get the path to the relevant data
function path = get_path_string(name)

% Get the stored path
path = user_string(name);

% Set the path validation function
if strcmp(name, 'symmetries')
    isvalid = @isvalid_sym;
else
    isvalid = @isvalid_;
end

% Check it is valid
if isvalid(path)
    return
end

% Ask the user to select the path
ismac = strncmp(computer, 'MAC', 3); % Is a Mac
message = sprintf('Path to %s required. Please locate the base directory.', name);
while 1
    if ismac
        % Give separate warning as the uigetdir dialogue box doesn't have a
        % title
        uiwait(warndlg(message))
    end
    path = uigetdir('/', message);
    if isequal(path, 0)
        % User hit cancel or closed window
        error('Valid path to %s not found.', name);
        return
    end
    if isvalid(path)
        user_string(name, path);
        return
    end
end

% Function to check the bath points to a valid file tree
function valid = isvalid_(path)
valid = exist(fullfile(path, 'bearing1', '001'), 'dir');

% Function to check there is a valid symmetry file
function valid = isvalid_sym(path)
valid = exist(fullfile(path, 'bearing1.symrot'), 'file');