function modes = intrinsic_hough(votes)

% Note, this intrinsic Hough does not refine modes with a step of mean
% shift at the end.

% SRT distance parameters
sigma_s = 0.0694444;
sigma_r = 0.12;
sigma_t = 0.12;

% Non-maximal suppresion parameter
gamma = exp(-8);

% Vote structure:
% 1 - weight
% 2 - object class
% 3:5 - translation
% 6 - scale
% 7:10 - rotation (quaternion)
% 11 - test feature id
% 12 - training feature id
% Added on here:
% 13 - log(scale)
% 14 - 1 ./ ((sigma_t * scale) .^ 2)
% 15 - translation' * translation

votes(15,:) = sum(votes(3:5,:) .^ 2);
votes(14,:) = 1 ./ ((sigma_t * votes(6,:)) .^ 2);
votes(13,:) = log(votes(6,:));

nclasses = double(max(votes(2,:)));
nvotes = size(votes, 2);

class_lists = accumarray(votes(2,:)', (1:nvotes)', [nclasses 1], @(I) {I});

% Compute a sparse matrix of weights of votes, using SRT distance with
% given sigmas, assuming a given vote is the mean
W = sparse([], [], [], nvotes, nvotes, nvotes*3000);
for a = 1:100:nvotes
    for b = a:min(a+99, nvotes)
        W(class_lists{votes(2,b)},b) = compute_weights(votes, b, class_lists{votes(2,b)}, sigma_s, sigma_r);
    end
    ojw_progressbar('Computing weights', a/nvotes);
end
ojw_progressbar('Computing weights', 1);

% Intrinsic Hough
weights = double(votes(1,:)');
sparse_diag = @(X) sparse(1:nvotes, 1:nvotes, X, nvotes, nvotes, nvotes);
IH = full(sum(sparse_diag(weights) * W, 1));

% Non-maximal suppression
L = find(IH == max(sparse_diag(IH) * (W > gamma), [], 1));
modes = votes(1:10,L);
IH = IH(L);
modes(1,:) = IH;

% Sort the modes in descending order of weight
[IH IH] = sort(IH, 'descend');
modes = modes(:,IH);

function D = compute_weights(votes, m, L, sigma_s, sigma_r)
Ds = votes(13,L) - votes(13,m);
Ds = Ds / sigma_s;
Ds = Ds .* Ds;
Dr = 1 - abs(votes(7:10,m)' * votes(7:10,L));
Dr = Dr / (sigma_r .^ 2);
Dt = bsxfun(@times, votes(15,m) + votes(15,L) - (2 * votes(3:5,m)') * votes(3:5,L), votes(14,L));
D = exp(-0.5 * (Ds + Dr + Dt));
D(D<1e-6) = 0;




