%RENDER_FEATURES Render the feature locations, scales and orientations

function render_features(P)
% P = [tx ty tx s qw qx qy qz]';

% Convert rotation to the required format
R = quat2rot(P(5:8,:));

% Plot the coordinate axes
plot3([P(1,:); P(1,:)+reshape(R(1,1,:), 1, []).*P(4,:)], [P(2,:); P(2,:)+reshape(R(2,1,:), 1, []).*P(4,:)], [P(3,:); P(3,:)+reshape(R(3,1,:), 1, []).*P(4,:)], 'r-');
plot3([P(1,:); P(1,:)+reshape(R(1,2,:), 1, []).*P(4,:)], [P(2,:); P(2,:)+reshape(R(2,2,:), 1, []).*P(4,:)], [P(3,:); P(3,:)+reshape(R(3,2,:), 1, []).*P(4,:)], 'g-');
plot3([P(1,:); P(1,:)+reshape(R(1,3,:), 1, []).*P(4,:)], [P(2,:); P(2,:)+reshape(R(2,3,:), 1, []).*P(4,:)], [P(3,:); P(3,:)+reshape(R(3,3,:), 1, []).*P(4,:)], 'b-');

% Plot the spheres
[x y z] = sphere(10);
for a = 1:size(P, 2)
    h = surface(double(x*P(4,a)+P(1,a)), double(y*P(4,a)+P(2,a)), double(z*P(4,a)+P(3,a)), 'FaceColor', [0.7 0 0], 'EdgeColor', 'none');
    alpha(h, 0.2);
end


