function Q = rot2quat(R)
%ROT2QUAT Convert a 3x3 rotation matrix to a quaternion
%
% Q = rot2quat(R)

[m n] = max([1, 1, 1; 1, -1, -1; -1, 1, -1; -1, -1, 1] * diag(R));
m = sqrt(1 + m) / 2;
Q = zeros(4, 1);
Q(n) = m;
m = 1 / (4 * m);

switch n
    case 1
        Q(2) = (R(3,2) - R(2,3)) * m;
        Q(3) = (R(1,3) - R(3,1)) * m;
        Q(4) = (R(2,1) - R(1,2)) * m;
    case 2
        Q(1) = (R(3,2) - R(2,3)) * m;
        Q(3) = (R(1,2) + R(2,1)) * m;
        Q(4) = (R(1,3) + R(3,1)) * m;
    case 3
        Q(1) = (R(1,3) - R(3,1)) * m;
        Q(2) = (R(1,2) + R(2,1)) * m;
        Q(4) = (R(2,3) + R(3,2)) * m;
    case 4
        Q(1) = (R(2,1) - R(1,2)) * m;
        Q(2) = (R(1,3) + R(3,1)) * m;
        Q(3) = (R(2,3) + R(3,2)) * m;
end